# Pickcel Dashboard Screen Mapper

A Chrome extension for capturing and selecting screen areas for the Pickcel Dashboard app. This extension allows users to easily select specific areas of their screen and generate code snippets that can be used in the dashboard application.

## Features

- **Screen Area Selection**: Click and drag to select any area of your screen
- **Code Generation**: Automatically generates code snippets for selected areas
- **Easy Integration**: Copy and paste generated code directly into your dashboard app
- **User-Friendly Interface**: Simple and intuitive popup interface

## Installation Process

1. Download or clone this repository to your local machine
2. Open Chrome and navigate to `chrome://extensions/`
3. Enable "Developer mode" in the top right corner
4. Click "Load unpacked" and select the extension folder
5. The extension will be installed and ready to use

For detailed installation instructions, refer to the [Chrome Extension Development Guide](https://developer.chrome.com/docs/extensions/mv3/getstarted/development-basics/)

## Getting Started

1. **Launch the Extension**: Click on the Pickcel Dashboard Screen Mapper icon in your Chrome toolbar
2. **Select Area**: Click the "Select Area" button to start screen area selection
3. **Draw Selection**: Click and drag your mouse to select the desired screen area
4. **Confirm Selection**: Click the confirm button to finalize your selection
5. **Copy Code**: Copy the generated code snippet
6. **Use in Dashboard**: Paste the code into your Pickcel Dashboard app

## How It Works

The extension uses Chrome's scripting API to capture screen areas and generate corresponding code snippets. The selected area coordinates and dimensions are processed to create reusable code that can be integrated into your dashboard application.

## Version

Current Version: 1.0.0

## Support

For support or questions, please contact the development team.

---

## Conventional Commits

To ensure clear communication and consistency in our commit messages, we follow a slightly modified [conventional commit](https://www.conventionalcommits.org/) message pattern. Please use the following commit message types:

-   **fix**: A bug fix or resolution for an issue.
-   **feat**: Introducing a new module or adding a new feature.
-   **perf**: Performance improvements or optimizations.
-   **chore**: Changes related to package updates like adding/updating/removing packages.
-   **refactor**: Code changes that improve code structure without fixing a bug or adding a feature.
-   **docs**: Documentation-related changes, including additions, deletions, or edits (both API docs and Markdown files).
-   **test**: Additions or modifications of tests.
-   **revert / merge**: Commit messages for respective actions of reverting or merging changes.
-   **ci**: Changes to continuous integration configuration.
-   **build**: Changes in build configuration like Webpack config, tsconfig, or build scripts like dev, start, etc.
-   **style**: Addition / modification regarding styling

For more information on this, please refer to the [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/) specification.
